/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.mraid;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.adsdk.sdk.BannerAd;
import com.adsdk.sdk.banner.InAppWebView;
import com.adsdk.sdk.mraid.MoPubView;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class AdView
extends WebView {
    public static final String AD_ORIENTATION_PORTRAIT_ONLY = "p";
    public static final String AD_ORIENTATION_LANDSCAPE_ONLY = "l";
    public static final String AD_ORIENTATION_BOTH = "b";
    public static final String DEVICE_ORIENTATION_PORTRAIT = "p";
    public static final String DEVICE_ORIENTATION_LANDSCAPE = "l";
    public static final String DEVICE_ORIENTATION_SQUARE = "s";
    public static final String DEVICE_ORIENTATION_UNKNOWN = "u";
    public static final String EXTRA_AD_CLICK_DATA = "com.mopub.intent.extra.AD_CLICK_DATA";
    private static final int MINIMUM_REFRESH_TIME_MILLISECONDS = 10000;
    private static final FrameLayout.LayoutParams WRAP_AND_CENTER_LAYOUT_PARAMS = new FrameLayout.LayoutParams(-2, -2, 17);
    private String mAdUnitId;
    private String mKeywords;
    private String mUrl;
    private String mClickthroughUrl;
    private String mRedirectUrl;
    private String mFailUrl;
    private String mImpressionUrl;
    private Location mLocation;
    private boolean mIsLoading;
    private boolean mAutorefreshEnabled;
    private int mRefreshTimeMilliseconds = 60000;
    private int mWidth;
    private int mHeight;
    private String mAdOrientation;
    private BannerAd mResponse;
    protected MoPubView mMoPubView;
    private String mResponseString;
    private String mUserAgent;
    private boolean mIsDestroyed;
    private final Handler mHandler = new Handler();
    private Handler mRefreshHandler = new Handler();
    private Runnable mRefreshRunnable = new Runnable(){

        @Override
        public void run() {
            AdView.this.loadAd();
        }
    };

    public AdView(Context context, MoPubView view, BannerAd response) {
        super(context.getApplicationContext());
        this.mResponse = response;
        this.mMoPubView = view;
        this.mAutorefreshEnabled = true;
        this.mUserAgent = this.getSettings().getUserAgentString();
        this.disableScrollingAndZoom();
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setPluginsEnabled(true);
        this.setBackgroundColor(0);
        this.setWebViewClient(new AdWebViewClient());
        this.addMoPubUriJavascriptInterface();
    }

    private void disableScrollingAndZoom() {
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.getSettings().setSupportZoom(false);
    }

    private void addMoPubUriJavascriptInterface() {
        final class MoPubUriJavascriptInterface {
            MoPubUriJavascriptInterface() {
            }

            public boolean fireFinishLoad() {
                AdView.this.postHandlerRunnable(new Runnable(){

                    @Override
                    public void run() {
                        AdView.this.adDidLoad();
                    }
                });
                return true;
            }
        }
        this.addJavascriptInterface(new MoPubUriJavascriptInterface(), "mopubUriInterface");
    }

    private void postHandlerRunnable(Runnable r) {
        this.mHandler.post(r);
    }

    public void loadAd() {
        HashMap<String, String> paramsHash = new HashMap<String, String>();
        paramsHash.put("X-Adtype", "mraid");
        paramsHash.put("X-Nativeparams", this.mResponse.getText());
        MoPubView mpv = this.mMoPubView;
        mpv.loadNativeSDK(paramsHash);
    }

    private boolean isNetworkAvailable() {
        String permission;
        Context context = this.getContext();
        int result = context.checkCallingPermission(permission = "android.permission.ACCESS_NETWORK_STATE");
        if (result == -1) {
            return true;
        }
        ConnectivityManager cm = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private Location getLastKnownLocation() {
        MoPubView.LocationAwareness locationAwareness = this.mMoPubView.getLocationAwareness();
        int locationPrecision = this.mMoPubView.getLocationPrecision();
        Location result = null;
        if (locationAwareness == MoPubView.LocationAwareness.LOCATION_AWARENESS_DISABLED) {
            return null;
        }
        LocationManager lm = (LocationManager)this.getContext().getSystemService("location");
        Location gpsLocation = null;
        try {
            gpsLocation = lm.getLastKnownLocation("gps");
        }
        catch (SecurityException e) {
            Log.d((String)"MoPub", (String)"Failed to retrieve GPS location: access appears to be disabled.");
        }
        catch (IllegalArgumentException e) {
            Log.d((String)"MoPub", (String)"Failed to retrieve GPS location: device has no GPS provider.");
        }
        Location networkLocation = null;
        try {
            networkLocation = lm.getLastKnownLocation("network");
        }
        catch (SecurityException e) {
            Log.d((String)"MoPub", (String)"Failed to retrieve network location: access appears to be disabled.");
        }
        catch (IllegalArgumentException e) {
            Log.d((String)"MoPub", (String)"Failed to retrieve network location: device has no network provider.");
        }
        if (gpsLocation == null && networkLocation == null) {
            return null;
        }
        result = gpsLocation != null && networkLocation != null ? (gpsLocation.getTime() > networkLocation.getTime() ? gpsLocation : networkLocation) : (gpsLocation != null ? gpsLocation : networkLocation);
        if (locationAwareness == MoPubView.LocationAwareness.LOCATION_AWARENESS_TRUNCATED) {
            double lat = result.getLatitude();
            double truncatedLat = BigDecimal.valueOf(lat).setScale(locationPrecision, 5).doubleValue();
            result.setLatitude(truncatedLat);
            double lon = result.getLongitude();
            double truncatedLon = BigDecimal.valueOf(lon).setScale(locationPrecision, 5).doubleValue();
            result.setLongitude(truncatedLon);
        }
        return result;
    }

    private String getTimeZoneOffsetString() {
        SimpleDateFormat format = new SimpleDateFormat("Z");
        format.setTimeZone(TimeZone.getDefault());
        return format.format(new Date());
    }

    protected void configureAdViewUsingHeadersFromHttpResponse(HttpResponse response) {
        Header orHeader;
        Header rdHeader;
        Header ntHeader = response.getFirstHeader("X-Networktype");
        if (ntHeader != null) {
            Log.i((String)"MoPub", (String)("Fetching ad network type: " + ntHeader.getValue()));
        }
        this.mRedirectUrl = (rdHeader = response.getFirstHeader("X-Launchpage")) != null ? rdHeader.getValue() : null;
        Header ctHeader = response.getFirstHeader("X-Clickthrough");
        this.mClickthroughUrl = ctHeader != null ? ctHeader.getValue() : null;
        Header flHeader = response.getFirstHeader("X-Failurl");
        this.mFailUrl = flHeader != null ? flHeader.getValue() : null;
        Header imHeader = response.getFirstHeader("X-Imptracker");
        this.mImpressionUrl = imHeader != null ? imHeader.getValue() : null;
        Header scHeader = response.getFirstHeader("X-Scrollable");
        boolean enabled = false;
        if (scHeader != null) {
            enabled = scHeader.getValue().equals("1");
        }
        this.setWebViewScrollingEnabled(enabled);
        Header wHeader = response.getFirstHeader("X-Width");
        Header hHeader = response.getFirstHeader("X-Height");
        if (wHeader != null && hHeader != null) {
            this.mWidth = Integer.parseInt(wHeader.getValue().trim());
            this.mHeight = Integer.parseInt(hHeader.getValue().trim());
        } else {
            this.mWidth = 0;
            this.mHeight = 0;
        }
        Header rtHeader = response.getFirstHeader("X-Refreshtime");
        if (rtHeader != null) {
            this.mRefreshTimeMilliseconds = Integer.valueOf(rtHeader.getValue()) * 1000;
            if (this.mRefreshTimeMilliseconds < 10000) {
                this.mRefreshTimeMilliseconds = 10000;
            }
        } else {
            this.mRefreshTimeMilliseconds = 0;
        }
        this.mAdOrientation = (orHeader = response.getFirstHeader("X-Orientation")) != null ? orHeader.getValue() : null;
    }

    private void setWebViewScrollingEnabled(boolean enabled) {
        if (enabled) {
            this.setOnTouchListener(null);
        } else {
            this.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return event.getAction() == 2;
                }
            });
        }
    }

    private void adDidLoad() {
        Log.i((String)"MoPub", (String)"Ad successfully loaded.");
        this.mIsLoading = false;
        this.scheduleRefreshTimerIfEnabled();
        this.setAdContentView((View)this, this.getHtmlAdLayoutParams());
        this.mMoPubView.adLoaded();
    }

    public void setAdContentView(View view) {
        this.setAdContentView(view, WRAP_AND_CENTER_LAYOUT_PARAMS);
    }

    private void setAdContentView(View view, FrameLayout.LayoutParams layoutParams) {
        this.mMoPubView.removeAllViews();
        this.mMoPubView.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    private void adDidFail() {
        Log.i((String)"MoPub", (String)"Ad failed to load.");
        this.mIsLoading = false;
        this.scheduleRefreshTimerIfEnabled();
        this.mMoPubView.adFailed();
    }

    private void adDidClose() {
        this.mMoPubView.adClosed();
    }

    private void handleCustomIntentFromUri(Uri uri) {
        this.registerClick();
        String action = uri.getQueryParameter("fnc");
        String adData = uri.getQueryParameter("data");
        Intent customIntent = new Intent(action);
        customIntent.addFlags(0x10000000);
        if (adData != null) {
            customIntent.putExtra(EXTRA_AD_CLICK_DATA, adData);
        }
        try {
            this.getContext().startActivity(customIntent);
        }
        catch (ActivityNotFoundException e) {
            Log.w((String)"MoPub", (String)("Could not handle custom intent: " + action + ". Is your intent spelled correctly?"));
        }
    }

    private void showBrowserForUrl(String url) {
        if (this.isDestroyed()) {
            return;
        }
        if (url == null || url.equals("")) {
            url = "about:blank";
        }
        Log.d((String)"MoPub", (String)("Final URI to show in browser: " + url));
        Context context = this.getContext();
        if (url.endsWith(".mp4")) {
            Intent i = new Intent("android.intent.action.VIEW");
            i.setDataAndType(Uri.parse((String)url), "video/mp4");
            context.startActivity(i);
        } else {
            Intent intent = new Intent(context, InAppWebView.class);
            intent.putExtra("REDIRECT_URI", url);
            intent.addFlags(0x10000000);
            try {
                context.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                String action = intent.getAction();
                Log.w((String)"MoPub", (String)("Could not handle intent action: " + action + ". Perhaps you forgot to declare com.adsdk.sdk.mraid.MraidBrowser" + " in your Android manifest file."));
                this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)"about:blank")).addFlags(0x10000000));
            }
        }
    }

    public void customEventDidLoadAd() {
        this.mIsLoading = false;
        this.scheduleRefreshTimerIfEnabled();
    }

    public void customEventDidFailToLoadAd() {
        this.loadFailUrl();
    }

    public void customEventActionWillBegin() {
        this.registerClick();
    }

    protected boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    protected void cleanup() {
        if (this.mIsDestroyed) {
            return;
        }
        this.setAutorefreshEnabled(false);
        this.cancelRefreshTimer();
        this.destroy();
        this.mResponseString = null;
        this.mMoPubView.removeView((View)this);
        this.mMoPubView = null;
        this.mIsDestroyed = true;
    }

    public void reload() {
        Log.d((String)"MoPub", (String)("Reload ad: " + this.mUrl));
        this.loadUrl(this.mUrl);
    }

    public void loadFailUrl() {
        this.mIsLoading = false;
        if (this.mFailUrl != null) {
            Log.d((String)"MoPub", (String)("Loading failover url: " + this.mFailUrl));
            this.loadUrl(this.mFailUrl);
        } else {
            this.adDidFail();
        }
    }

    protected void registerClick() {
        if (this.mClickthroughUrl == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                DefaultHttpClient httpclient = new DefaultHttpClient();
                HttpGet httpget = new HttpGet(AdView.this.mClickthroughUrl);
                httpget.addHeader("User-Agent", AdView.this.mUserAgent);
                try {
                    try {
                        httpclient.execute((HttpUriRequest)httpget);
                    }
                    catch (ClientProtocolException e) {
                        Log.i((String)"MoPub", (String)("Click tracking failed: " + AdView.this.mClickthroughUrl));
                        httpclient.getConnectionManager().shutdown();
                    }
                    catch (IOException e) {
                        Log.i((String)"MoPub", (String)("Click tracking failed: " + AdView.this.mClickthroughUrl));
                        httpclient.getConnectionManager().shutdown();
                    }
                }
                finally {
                    httpclient.getConnectionManager().shutdown();
                }
            }
        }).start();
    }

    protected void adAppeared() {
        this.loadUrl("javascript:webviewDidAppear();");
    }

    protected void scheduleRefreshTimerIfEnabled() {
        this.cancelRefreshTimer();
        if (!this.mAutorefreshEnabled || this.mRefreshTimeMilliseconds <= 0) {
            return;
        }
        this.mRefreshHandler.postDelayed(this.mRefreshRunnable, (long)this.mRefreshTimeMilliseconds);
    }

    protected void cancelRefreshTimer() {
        this.mRefreshHandler.removeCallbacks(this.mRefreshRunnable);
    }

    protected int getRefreshTimeMilliseconds() {
        return this.mRefreshTimeMilliseconds;
    }

    protected void setRefreshTimeMilliseconds(int refreshTimeMilliseconds) {
        this.mRefreshTimeMilliseconds = refreshTimeMilliseconds;
    }

    private String addKeyword(String keywords, String addition) {
        if (addition == null || addition.length() == 0) {
            return keywords;
        }
        if (keywords == null || keywords.length() == 0) {
            return addition;
        }
        return String.valueOf(keywords) + "," + addition;
    }

    public String getKeywords() {
        return this.mKeywords;
    }

    public void setKeywords(String keywords) {
        this.mKeywords = keywords;
    }

    public Location getLocation() {
        return this.mLocation;
    }

    public void setLocation(Location location) {
        this.mLocation = location;
    }

    public String getAdUnitId() {
        return this.mAdUnitId;
    }

    public void setAdUnitId(String adUnitId) {
        this.mAdUnitId = adUnitId;
    }

    public int getAdWidth() {
        return this.mWidth;
    }

    public int getAdHeight() {
        return this.mHeight;
    }

    public String getAdOrientation() {
        return this.mAdOrientation;
    }

    public String getClickthroughUrl() {
        return this.mClickthroughUrl;
    }

    public void setClickthroughUrl(String url) {
        this.mClickthroughUrl = url;
    }

    public String getRedirectUrl() {
        return this.mRedirectUrl;
    }

    public String getResponseString() {
        return this.mResponseString;
    }

    protected void setResponseString(String responseString) {
        this.mResponseString = responseString;
    }

    protected void setIsLoading(boolean isLoading) {
        this.mIsLoading = isLoading;
    }

    public void setAutorefreshEnabled(boolean enabled) {
        this.mAutorefreshEnabled = enabled;
        Log.d((String)"MoPub", (String)("Automatic refresh for " + this.mAdUnitId + " set to: " + enabled + "."));
        if (!this.mAutorefreshEnabled) {
            this.cancelRefreshTimer();
        } else {
            this.scheduleRefreshTimerIfEnabled();
        }
    }

    public boolean getAutorefreshEnabled() {
        return this.mAutorefreshEnabled;
    }

    public void forceRefresh() {
        this.mIsLoading = false;
        this.loadAd();
    }

    private FrameLayout.LayoutParams getHtmlAdLayoutParams() {
        if (this.mWidth > 0 && this.mHeight > 0) {
            DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
            int scaledWidth = (int)TypedValue.applyDimension((int)1, (float)this.mWidth, (DisplayMetrics)displayMetrics);
            int scaledHeight = (int)TypedValue.applyDimension((int)1, (float)this.mHeight, (DisplayMetrics)displayMetrics);
            return new FrameLayout.LayoutParams(scaledWidth, scaledHeight, 17);
        }
        return WRAP_AND_CENTER_LAYOUT_PARAMS;
    }

    private class AdWebViewClient
    extends WebViewClient {
        private AdWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            AdView adView = (AdView)view;
            if (url.startsWith("mopub://")) {
                Uri uri = Uri.parse((String)url);
                String host = uri.getHost();
                if (host.equals("finishLoad")) {
                    adView.adDidLoad();
                } else if (host.equals("close")) {
                    adView.adDidClose();
                } else if (host.equals("failLoad")) {
                    adView.loadFailUrl();
                } else if (host.equals("custom")) {
                    adView.handleCustomIntentFromUri(uri);
                }
                return true;
            }
            if (url.startsWith("tel:") || url.startsWith("voicemail:") || url.startsWith("sms:") || url.startsWith("mailto:") || url.startsWith("geo:") || url.startsWith("google.streetview:")) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                intent.addFlags(0x10000000);
                try {
                    AdView.this.getContext().startActivity(intent);
                    AdView.this.registerClick();
                }
                catch (ActivityNotFoundException e) {
                    Log.w((String)"MoPub", (String)("Could not handle intent with URI: " + url + ". Is this intent unsupported on your phone?"));
                }
                return true;
            }
            if (url.startsWith("market://")) {
                boolean isIntentSafe;
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                PackageManager packageManager = AdView.this.getContext().getPackageManager();
                List activities = packageManager.queryIntentActivities(intent, 0);
                boolean bl = isIntentSafe = activities.size() > 0;
                if (!isIntentSafe) {
                    Log.w((String)"MoPub", (String)("Could not handle market action: " + url + ". Perhaps you're running in the emulator, which does not have " + "the Android Market?"));
                    return true;
                }
            }
            url = this.urlWithClickTrackingRedirect(adView, url);
            Log.d((String)"MoPub", (String)("Ad clicked. Click URL: " + url));
            AdView.this.mMoPubView.adClicked();
            AdView.this.showBrowserForUrl(url);
            return true;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            AdView adView = (AdView)view;
            String redirectUrl = adView.getRedirectUrl();
            if (redirectUrl != null && url.startsWith(redirectUrl)) {
                url = this.urlWithClickTrackingRedirect(adView, url);
                view.stopLoading();
                AdView.this.showBrowserForUrl(url);
            }
        }

        private String urlWithClickTrackingRedirect(AdView adView, String url) {
            String clickthroughUrl = adView.getClickthroughUrl();
            if (clickthroughUrl == null) {
                return url;
            }
            String encodedUrl = Uri.encode((String)url);
            return String.valueOf(clickthroughUrl) + "&r=" + encodedUrl;
        }
    }
}

