/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import android.content.Context;
import android.graphics.Canvas;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.TextView;

public class AutoResizeTextView
extends TextView {
    public static final float MIN_TEXT_SIZE = 20.0f;
    private static final Canvas sTextResizeCanvas = new Canvas();
    private static final String mEllipsis = "...";
    private OnTextResizeListener mTextResizeListener;
    private boolean mNeedsResize = false;
    private float mTextSize = this.getTextSize();
    private float mMaxTextSize = 0.0f;
    private float mMinTextSize = 20.0f;
    private float mSpacingMult = 1.0f;
    private float mSpacingAdd = 0.0f;
    private boolean mAddEllipsis = true;

    public AutoResizeTextView(Context context) {
        this(context, null);
    }

    public AutoResizeTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AutoResizeTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        this.mNeedsResize = true;
        this.resetTextSize();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (w != oldw || h != oldh) {
            this.mNeedsResize = true;
        }
    }

    public void setOnResizeListener(OnTextResizeListener listener) {
        this.mTextResizeListener = listener;
    }

    public void setTextSize(float size) {
        super.setTextSize(size);
        this.mTextSize = this.getTextSize();
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(unit, size);
        this.mTextSize = this.getTextSize();
    }

    public void setLineSpacing(float add, float mult) {
        super.setLineSpacing(add, mult);
        this.mSpacingMult = mult;
        this.mSpacingAdd = add;
    }

    public void setMaxTextSize(float maxTextSize) {
        this.mMaxTextSize = maxTextSize;
        this.requestLayout();
        this.invalidate();
    }

    public float getMaxTextSize() {
        return this.mMaxTextSize;
    }

    public void setMinTextSize(float minTextSize) {
        this.mMinTextSize = minTextSize;
        this.requestLayout();
        this.invalidate();
    }

    public float getMinTextSize() {
        return this.mMinTextSize;
    }

    public void setAddEllipsis(boolean addEllipsis) {
        this.mAddEllipsis = addEllipsis;
    }

    public boolean getAddEllipsis() {
        return this.mAddEllipsis;
    }

    public void resetTextSize() {
        super.setTextSize(0, this.mTextSize);
        this.mMaxTextSize = this.mTextSize;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (changed || this.mNeedsResize) {
            int widthLimit = right - left - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
            int heightLimit = bottom - top - this.getCompoundPaddingBottom() - this.getCompoundPaddingTop();
            this.resizeText(widthLimit, heightLimit);
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    public void resizeText() {
        int heightLimit = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        int widthLimit = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        this.resizeText(widthLimit, heightLimit);
    }

    public void resizeText(int width, int height) {
        CharSequence text = this.getText();
        if (text == null || text.length() == 0 || height <= 0 || width <= 0 || this.mTextSize == 0.0f) {
            return;
        }
        TextPaint textPaint = this.getPaint();
        float oldTextSize = textPaint.getTextSize();
        float targetTextSize = this.mMaxTextSize > 0.0f ? Math.min(this.mTextSize, this.mMaxTextSize) : this.mTextSize;
        int textHeight = this.getTextHeight(text, textPaint, width, targetTextSize);
        while (textHeight > height && targetTextSize > this.mMinTextSize) {
            targetTextSize = Math.max(targetTextSize - 2.0f, this.mMinTextSize);
            textHeight = this.getTextHeight(text, textPaint, width, targetTextSize);
        }
        if (this.mAddEllipsis && targetTextSize == this.mMinTextSize && textHeight > height) {
            StaticLayout layout = new StaticLayout(text, textPaint, width, Layout.Alignment.ALIGN_NORMAL, this.mSpacingMult, this.mSpacingAdd, false);
            layout.draw(sTextResizeCanvas);
            if (layout.getLineCount() > 0) {
                int lastLine = layout.getLineForVertical(height) - 1;
                if (lastLine < 0) {
                    this.setText("");
                } else {
                    int start = layout.getLineStart(lastLine);
                    int end = layout.getLineEnd(lastLine);
                    float lineWidth = layout.getLineWidth(lastLine);
                    float ellipseWidth = textPaint.measureText(mEllipsis);
                    while ((float)width < lineWidth + ellipseWidth) {
                        lineWidth = textPaint.measureText(text.subSequence(start, --end + 1).toString());
                    }
                    this.setText(text.subSequence(0, end) + mEllipsis);
                }
            }
        }
        textPaint.setTextSize(targetTextSize);
        this.setLineSpacing(this.mSpacingAdd, this.mSpacingMult);
        if (this.mTextResizeListener != null) {
            this.mTextResizeListener.onTextResize(this, oldTextSize, targetTextSize);
        }
        this.mNeedsResize = false;
    }

    private int getTextHeight(CharSequence source, TextPaint paint, int width, float textSize) {
        paint.setTextSize(textSize);
        StaticLayout layout = new StaticLayout(source, paint, width, Layout.Alignment.ALIGN_NORMAL, this.mSpacingMult, this.mSpacingAdd, true);
        layout.draw(sTextResizeCanvas);
        return layout.getHeight();
    }

    public static interface OnTextResizeListener {
        public void onTextResize(TextView var1, float var2, float var3);
    }
}

