/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.adsdk.sdk.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Locale;
import java.util.UUID;

public class Util {
    private static int sFadeInAnimationId = 0;
    private static int sFadeOutAnimationId = 0;
    private static int sSlideInRightAnimationId = 0;
    private static int sSlideOutRightAnimationId = 0;
    private static int sSlideInLeftAnimationId = 0;
    private static int sSlideOutLeftAnimationId = 0;
    private static int sSlideInTopAnimationId = 0;
    private static int sSlideOutTopAnimationId = 0;
    private static int sSlideInBottomAnimationId = 0;
    private static int sSlideOutBottomAnimationId = 0;

    public static boolean isNetworkAvailable(Context ctx) {
        int networkStatePermission = ctx.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
        if (networkStatePermission == 0) {
            ConnectivityManager mConnectivity = (ConnectivityManager)ctx.getSystemService("connectivity");
            NetworkInfo info = mConnectivity.getActiveNetworkInfo();
            if (info == null) {
                return false;
            }
            int netType = info.getType();
            if (netType == 1 || netType == 0) {
                return info.isConnected();
            }
            return false;
        }
        return true;
    }

    public static String getConnectionType(Context context) {
        int networkStatePermission = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
        if (networkStatePermission == 0) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = cm.getActiveNetworkInfo();
            if (info == null) {
                return "UNKNOWN";
            }
            int netType = info.getType();
            int netSubtype = info.getSubtype();
            if (netType == 1) {
                return "WIFI";
            }
            if (netType == 6) {
                return "WIMAX";
            }
            if (netType == 0) {
                switch (netSubtype) {
                    case 7: {
                        return "1xRTT";
                    }
                    case 4: {
                        return "CDMA";
                    }
                    case 2: {
                        return "EDGE";
                    }
                    case 5: {
                        return "EVDO_0";
                    }
                    case 6: {
                        return "EVDO_A";
                    }
                    case 1: {
                        return "GPRS";
                    }
                    case 3: {
                        return "UMTS";
                    }
                    case 14: {
                        return "EHRPD";
                    }
                    case 12: {
                        return "EVDO_B";
                    }
                    case 8: {
                        return "HSDPA";
                    }
                    case 10: {
                        return "HSPA";
                    }
                    case 15: {
                        return "HSPAP";
                    }
                    case 9: {
                        return "HSUPA";
                    }
                    case 11: {
                        return "IDEN";
                    }
                    case 13: {
                        return "LTE";
                    }
                }
                return "MOBILE";
            }
            return "UNKNOWN";
        }
        return "UNKNOWN";
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException ex) {
            Log.e(ex.toString());
        }
        return null;
    }

    public static String getTelephonyDeviceId(Context context) {
        int telephonyPermission = context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE");
        if (telephonyPermission == 0) {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            return tm.getDeviceId();
        }
        return "";
    }

    public static String getDeviceId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (androidId == null || androidId.equals("9774d56d682e549c") || androidId.equals("0000000000000000")) {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            androidId = prefs.getString("device_id", null);
            if (androidId == null) {
                try {
                    String uuid = UUID.randomUUID().toString();
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    digest.update(uuid.getBytes(), 0, uuid.length());
                    androidId = String.format("%032X", new BigInteger(1, digest.digest())).substring(0, 16);
                }
                catch (Exception e) {
                    Log.d("Could not generate pseudo unique id", e);
                    androidId = "9774d56d682e549c";
                }
                prefs.edit().putString("device_id", androidId).commit();
            }
            Log.d("Unknown Android ID using pseudo unique id:" + androidId);
        }
        return androidId;
    }

    public static Location getLocation(Context context) {
        LocationManager locationManager;
        int isAccessFineLocation = context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION");
        int isAccessCoarseLocation = context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION");
        if ((isAccessFineLocation == 0 || isAccessCoarseLocation == 0) && (locationManager = (LocationManager)context.getSystemService("location")) != null) {
            boolean isNetworkEnabled;
            boolean isGpsEnabled;
            if (isAccessFineLocation == 0 && (isGpsEnabled = locationManager.isProviderEnabled("gps"))) {
                return locationManager.getLastKnownLocation("gps");
            }
            if (isAccessCoarseLocation == 0 && (isNetworkEnabled = locationManager.isProviderEnabled("network"))) {
                return locationManager.getLastKnownLocation("network");
            }
        }
        return null;
    }

    public static String getDefaultUserAgentString(Context context) {
        Constructor constructor = WebSettings.class.getDeclaredConstructor(Context.class, WebView.class);
        constructor.setAccessible(true);
        try {
            WebSettings settings = (WebSettings)constructor.newInstance(context, null);
            String string = settings.getUserAgentString();
            constructor.setAccessible(false);
            return string;
        }
        catch (Throwable throwable) {
            try {
                constructor.setAccessible(false);
                throw throwable;
            }
            catch (Exception e) {
                return new WebView(context).getSettings().getUserAgentString();
            }
        }
    }

    public static String buildUserAgent() {
        String androidVersion = Build.VERSION.RELEASE;
        String model = Build.MODEL;
        String androidBuild = Build.ID;
        Locale l = Locale.getDefault();
        String language = l.getLanguage();
        String locale = "en";
        if (language != null) {
            locale = language.toLowerCase();
            String country = l.getCountry();
            if (country != null) {
                locale = String.valueOf(locale) + "-" + country.toLowerCase();
            }
        }
        String userAgent = String.format("Mozilla/5.0 (Linux; U; Android %1$s; %2$s; %3$s Build/%4$s) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1", androidVersion, locale, model, androidBuild);
        return userAgent;
    }

    public static int getMemoryClass(Context context) {
        try {
            Method getMemoryClassMethod = ActivityManager.class.getMethod("getMemoryClass", new Class[0]);
            ActivityManager ac = (ActivityManager)context.getSystemService("activity");
            return (Integer)getMemoryClassMethod.invoke((Object)ac, new Object[0]);
        }
        catch (Exception ex) {
            return 16;
        }
    }

    public static void initializeAnimations(Context ctx) {
        Resources r = ctx.getResources();
        sFadeInAnimationId = r.getIdentifier("fade_in", "anim", ctx.getPackageName());
        sFadeOutAnimationId = r.getIdentifier("fade_out", "anim", ctx.getPackageName());
        sSlideInBottomAnimationId = r.getIdentifier("slide_bottom_in", "anim", ctx.getPackageName());
        sSlideOutBottomAnimationId = r.getIdentifier("slide_bottom_out", "anim", ctx.getPackageName());
        sSlideInTopAnimationId = r.getIdentifier("slide_top_in", "anim", ctx.getPackageName());
        sSlideOutTopAnimationId = r.getIdentifier("slide_top_out", "anim", ctx.getPackageName());
        sSlideInLeftAnimationId = r.getIdentifier("slide_left_in", "anim", ctx.getPackageName());
        sSlideOutLeftAnimationId = r.getIdentifier("slide_left_out", "anim", ctx.getPackageName());
        sSlideInRightAnimationId = r.getIdentifier("slide_right_in", "anim", ctx.getPackageName());
        sSlideOutRightAnimationId = r.getIdentifier("slide_right_out", "anim", ctx.getPackageName());
    }

    public static AnimationSet getEnterAnimationSet(int animation) {
        AnimationSet set = new AnimationSet(false);
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        alphaAnimation.setDuration(3000L);
        set.addAnimation((Animation)alphaAnimation);
        switch (animation) {
            case 1: {
                return set;
            }
            case 6: {
                return set;
            }
            case 3: {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
                translateAnimation.setDuration(1000L);
                set.addAnimation((Animation)translateAnimation);
                return set;
            }
            case 4: {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, -1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
                translateAnimation.setDuration(1000L);
                set.addAnimation((Animation)translateAnimation);
                return set;
            }
            case 5: {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, 1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
                translateAnimation.setDuration(1000L);
                set.addAnimation((Animation)translateAnimation);
                return set;
            }
            case 2: {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, -1.0f, 1, 0.0f);
                translateAnimation.setDuration(1000L);
                set.addAnimation((Animation)translateAnimation);
                return set;
            }
        }
        return null;
    }

    public static AnimationSet getExitAnimationSet(int animation) {
        AnimationSet set = new AnimationSet(false);
        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        alphaAnimation.setDuration(3000L);
        set.addAnimation((Animation)alphaAnimation);
        switch (animation) {
            case 1: {
                return set;
            }
            case 6: {
                return set;
            }
            case 3: {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
                translateAnimation.setDuration(1000L);
                set.addAnimation((Animation)translateAnimation);
                return set;
            }
            case 4: {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, -1.0f, 1, 0.0f, 1, 0.0f);
                translateAnimation.setDuration(1000L);
                set.addAnimation((Animation)translateAnimation);
                return set;
            }
            case 5: {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 1.0f, 1, 0.0f, 1, 0.0f);
                translateAnimation.setDuration(1000L);
                set.addAnimation((Animation)translateAnimation);
                return set;
            }
            case 2: {
                TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, -1.0f);
                translateAnimation.setDuration(1000L);
                set.addAnimation((Animation)translateAnimation);
                return set;
            }
        }
        return null;
    }

    public static int getEnterAnimation(int animation) {
        switch (animation) {
            case 1: {
                return sFadeInAnimationId;
            }
            case 6: {
                return sFadeInAnimationId;
            }
            case 3: {
                return sSlideInBottomAnimationId;
            }
            case 4: {
                return sSlideInLeftAnimationId;
            }
            case 5: {
                return sSlideInRightAnimationId;
            }
            case 2: {
                return sSlideInTopAnimationId;
            }
        }
        return 0;
    }

    public static int getExitAnimation(int animation) {
        switch (animation) {
            case 1: {
                return sFadeOutAnimationId;
            }
            case 6: {
                return sFadeOutAnimationId;
            }
            case 3: {
                return sSlideOutBottomAnimationId;
            }
            case 4: {
                return sSlideOutLeftAnimationId;
            }
            case 5: {
                return sSlideOutRightAnimationId;
            }
            case 2: {
                return sSlideOutTopAnimationId;
            }
        }
        return 0;
    }
}

