/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import com.adsdk.sdk.AdRequest;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.RequestException;
import com.adsdk.sdk.video.ResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class RequestVideoList {
    public HashMap<String, Long> sendRequest(AdRequest request) throws RequestException {
        String url = String.valueOf(request.toString()) + "&listads=1";
        Log.d("Video List RequestPerform HTTP Get Url: " + url);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpConnectionParams.setSoTimeout((HttpParams)client.getParams(), (int)10000);
        HttpConnectionParams.setConnectionTimeout((HttpParams)client.getParams(), (int)10000);
        HttpProtocolParams.setUserAgent((HttpParams)client.getParams(), (String)request.getUserAgent());
        HttpGet get = new HttpGet(url);
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                return this.parse(response.getEntity().getContent());
            }
            throw new RequestException("Server Error. Response code:" + responseCode);
        }
        catch (RequestException e) {
            throw e;
        }
        catch (ClientProtocolException e) {
            throw new RequestException("Error in HTTP request", e);
        }
        catch (IOException e) {
            throw new RequestException("Error in HTTP request", e);
        }
        catch (Throwable t) {
            throw new RequestException("Error in HTTP request", t);
        }
    }

    private HashMap<String, Long> parse(InputStream inputStream) throws RequestException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            ResponseHandler myHandler = new ResponseHandler();
            xr.setContentHandler(myHandler);
            InputSource src = new InputSource(inputStream);
            src.setEncoding("ISO-8859-1");
            xr.parse(src);
            return myHandler.videoList;
        }
        catch (Exception e) {
            throw new RequestException("Cannot parse Response:" + e.getMessage(), e);
        }
    }
}

