/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.video;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.webkit.WebView;
import com.adsdk.sdk.Log;
import com.adsdk.sdk.video.RichMediaActivity;
import java.lang.reflect.Method;

public class WebViewClient
extends android.webkit.WebViewClient {
    private boolean mAllowNavigation = false;
    private Activity mActivity;
    private String mAllowedUrl;
    private long mFinishedLoadingTime;
    private OnPageLoadedListener mOnPageLoadedListener;

    public WebViewClient(Activity activity, boolean allowNavigation) {
        this.mActivity = activity;
        this.mAllowNavigation = allowNavigation;
        this.mFinishedLoadingTime = 0L;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Log.d("Loading url:" + url);
        if (url.startsWith("market:") || url.startsWith("http://market.android.com") || url.startsWith("sms:") || url.startsWith("tel:") || url.startsWith("mailto:") || url.startsWith("voicemail:") || url.startsWith("geo:") || url.startsWith("google.streetview:")) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            try {
                this.mActivity.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                Log.w("Could open URL: " + url);
            }
            return true;
        }
        if (url.startsWith("mfox:external:")) {
            url = url.substring(14);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.mActivity.startActivity(intent);
            return true;
        }
        if (url.startsWith("mfox:replayvideo")) {
            try {
                Class<?> c = this.mActivity.getClass();
                Method method = c.getMethod("replayVideo", new Class[0]);
                method.invoke((Object)this.mActivity, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Log.d("Your activity class has no replayVideo method");
            }
            catch (Exception e) {
                Log.d("Couldn't run replayVideo method in your Activity");
            }
            return true;
        }
        if (url.startsWith("mfox:playvideo")) {
            try {
                Class<?> c = this.mActivity.getClass();
                Method method = c.getMethod("playVideo", new Class[0]);
                method.invoke((Object)this.mActivity, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Log.d("Your activity class has no playVideo method");
            }
            catch (Exception e) {
                Log.d("Couldn't run replayVideo method in your Activity");
            }
            return true;
        }
        if (url.startsWith("mfox:skip")) {
            this.mActivity.finish();
            return true;
        }
        if (this.mAllowNavigation || url.equals(this.mAllowedUrl)) {
            view.loadUrl(url);
        } else {
            Intent intent = new Intent((Context)this.mActivity, RichMediaActivity.class);
            intent.setData(Uri.parse((String)url));
            this.mActivity.startActivity(intent);
        }
        return true;
    }

    public void setAllowedUrl(String url) {
        Uri uri;
        String path;
        this.mFinishedLoadingTime = 0L;
        this.mAllowedUrl = url;
        if (this.mAllowedUrl != null && ((path = (uri = Uri.parse((String)this.mAllowedUrl)).getPath()) == null || path.length() == 0)) {
            this.mAllowedUrl = String.valueOf(this.mAllowedUrl) + "/";
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        Log.d("onPageFinished:" + url + " mAllowedUrl:" + this.mAllowedUrl);
        if (this.mAllowedUrl == null || url.equals(this.mAllowedUrl)) {
            if (this.mFinishedLoadingTime == 0L) {
                this.mFinishedLoadingTime = System.currentTimeMillis();
            }
            if (this.mOnPageLoadedListener != null) {
                this.mOnPageLoadedListener.onPageLoaded();
            }
        }
    }

    public long getFinishedLoadingTime() {
        return this.mFinishedLoadingTime;
    }

    public String getAllowedUrl() {
        return this.mAllowedUrl;
    }

    public void setOnPageLoadedListener(OnPageLoadedListener l) {
        this.mOnPageLoadedListener = l;
    }

    public static interface OnPageLoadedListener {
        public void onPageLoaded();
    }
}

