/*
 * Decompiled with CFR 0.152.
 */
package com.adsdk.sdk.mraid;

import com.adsdk.sdk.mraid.MraidView;
import java.util.Map;

abstract class MraidCommand {
    protected Map<String, String> mParams;
    protected MraidView mView;

    MraidCommand(Map<String, String> params, MraidView view) {
        this.mParams = params;
        this.mView = view;
    }

    abstract void execute();

    protected int getIntFromParamsForKey(String key) {
        String s = this.mParams.get(key);
        if (s == null) {
            return -1;
        }
        try {
            return Integer.parseInt(s, 10);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected String getStringFromParamsForKey(String key) {
        return this.mParams.get(key);
    }

    protected float getFloatFromParamsForKey(String key) {
        String s = this.mParams.get(key);
        if (s == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(key);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    protected boolean getBooleanFromParamsForKey(String key) {
        return "true".equals(this.mParams.get(key));
    }
}

